"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpsertConsultantUserRequestModel = exports.UpsertConsultantHandler = exports.UpsertConsultantUserCommand = void 0;
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const dict_1 = require("../../../../constants/dict");
const place_entity_1 = require("../../../../db/entities/place.entity");
const typeorm_1 = require("typeorm");
const address_1 = require("../../../../model/address");
const user_entity_1 = require("../../../../db/entities/user.entity");
const consultant_entity_1 = require("../../../../db/entities/user/consultant.entity");
const class_validator_1 = require("class-validator");
const handled_error_1 = require("../../../../core/classes/handled-error");
const consultants = repositories_1.db.getRepository(consultant_entity_1.ConsultantEntity);
const places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
class UpsertConsultantUserCommand {
    constructor(dto, user) {
        this.dto = dto;
        this.user = user;
    }
}
exports.UpsertConsultantUserCommand = UpsertConsultantUserCommand;
let UpsertConsultantHandler = class UpsertConsultantHandler {
    async execute({ dto, user: current, }) {
        const { cityId, areasId, ...rest } = dto;
        const city = await places.findOneBy({ id: cityId });
        const areas = await places.findBy({ id: (0, typeorm_1.In)(areasId) });
        if (current.subscriberType === 'none') {
            current.subscriberType = 'consultant';
            const userNameExist = await consultants.findOneBy({
                userName: dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            await repositories_1.db.manager.update(user_entity_1.UserEntity, { id: current.id }, {
                ...rest,
                city,
                areas,
                subscriberType: 'consultant',
                type: 'ConsultantEntity',
            });
        }
        else {
            const userNameExist = await consultants.findOneBy({
                id: (0, typeorm_1.Not)(current.id),
                userName: dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            const consultant = await consultants.findOneBy({ id: current.id });
            consultant.update({ ...rest, city, areas });
            await consultant.save();
        }
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.UpsertConsultantHandler = UpsertConsultantHandler;
exports.UpsertConsultantHandler = UpsertConsultantHandler = __decorate([
    (0, cqrs_1.CommandHandler)(UpsertConsultantUserCommand)
], UpsertConsultantHandler);
class UpsertConsultantUserRequestModel {
}
exports.UpsertConsultantUserRequestModel = UpsertConsultantUserRequestModel;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "firstName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "userName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "licenseImg", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: address_1.LocationAddressModel }),
    __metadata("design:type", address_1.LocationAddressModel)
], UpsertConsultantUserRequestModel.prototype, "address", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "nationalCode", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertConsultantUserRequestModel.prototype, "cityId", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, swagger_1.ApiProperty)({ type: [String] }),
    __metadata("design:type", Array)
], UpsertConsultantUserRequestModel.prototype, "areasId", void 0);
//# sourceMappingURL=UpsertConsultantUser.js.map