"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpsertPersonalUserRequestModel = exports.UpsertPersonalUserHandler = exports.UpsertPersonalUserCommand = void 0;
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const handled_error_1 = require("../../../../core/classes/handled-error");
const dict_1 = require("../../../../constants/dict");
const user_entity_1 = require("../../../../db/entities/user.entity");
const person_entity_1 = require("../../../../db/entities/user/person.entity");
const typeorm_1 = require("typeorm");
const ds_1 = require("../../../../db/ds");
const class_validator_1 = require("class-validator");
const persons = repositories_1.db.getRepository(person_entity_1.PersonEntity);
const users = repositories_1.db.getRepository(user_entity_1.UserEntity);
class UpsertPersonalUserCommand {
    constructor(dto, user) {
        this.dto = dto;
        this.user = user;
    }
}
exports.UpsertPersonalUserCommand = UpsertPersonalUserCommand;
let UpsertPersonalUserHandler = class UpsertPersonalUserHandler {
    constructor() { }
    async execute(command) {
        const current = command.user;
        if (current.subscriberType === 'none') {
            const userNameExist = await persons.findOneBy({
                userName: command.dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            await ds_1.default.manager.update(user_entity_1.UserEntity, { id: current.id }, {
                ...command.dto,
                subscriberType: 'personal',
                type: 'PersonEntity',
            });
        }
        else {
            const userNameExist = await persons.findOneBy({
                id: (0, typeorm_1.Not)(current.id),
                userName: command.dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            const person = await persons.findOneBy({ id: current.id });
            person.update(command.dto);
            await person.save();
        }
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.UpsertPersonalUserHandler = UpsertPersonalUserHandler;
exports.UpsertPersonalUserHandler = UpsertPersonalUserHandler = __decorate([
    (0, cqrs_1.CommandHandler)(UpsertPersonalUserCommand),
    __metadata("design:paramtypes", [])
], UpsertPersonalUserHandler);
class UpsertPersonalUserRequestModel {
}
exports.UpsertPersonalUserRequestModel = UpsertPersonalUserRequestModel;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPersonalUserRequestModel.prototype, "firstName", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPersonalUserRequestModel.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPersonalUserRequestModel.prototype, "userName", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPersonalUserRequestModel.prototype, "nationalCode", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPersonalUserRequestModel.prototype, "nationalCardImg", void 0);
//# sourceMappingURL=UpsertPersonalUser.js.map