import { CommandBus, QueryBus } from '@nestjs/cqrs';
import { UpsertAgencyUserRequestModel, UpsertConsultantUserRequestModel, UpsertPersonalUserRequestModel } from '~modules/users/handlers';
import { UserEntity } from '~db/entities/user.entity';
export declare class UserController {
    private readonly command;
    private readonly queryBus;
    constructor(command: CommandBus, queryBus: QueryBus);
    upsertAgency(data: UpsertAgencyUserRequestModel, user: UserEntity): Promise<any>;
    upsertConsultant(data: UpsertConsultantUserRequestModel, user: UserEntity): Promise<any>;
    upsertPersonal(data: UpsertPersonalUserRequestModel, user: UserEntity): Promise<any>;
    getCurrentUer(user: UserEntity): Promise<UserEntity>;
}
