"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const moment_timezone_1 = require("moment-timezone");
const typeorm_1 = require("typeorm");
const SelectQueryBuilder_1 = require("typeorm/query-builder/SelectQueryBuilder");
SelectQueryBuilder_1.SelectQueryBuilder.prototype.regex = function (fields, value) {
    if (!!value) {
        this.andWhere(new typeorm_1.Brackets((qb) => {
            fields.forEach((x) => {
                qb.orWhere(`${x} like :value`, { value: `%${value}%` });
            });
        }));
    }
    return this;
};
SelectQueryBuilder_1.SelectQueryBuilder.prototype.paginate = function ({ offset = 1, size = 10 }) {
    const limit = Number(size);
    const skip = (Number(offset) - 1) * Number(limit);
    this.take(size).skip(skip);
    return this;
};
SelectQueryBuilder_1.SelectQueryBuilder.prototype.dateRange = function (key, { fromDate, toDate }) {
    if (fromDate && !toDate) {
        const from = (0, moment_timezone_1.default)(fromDate).toISOString();
        this.andWhere(`${key} > :from`, { from });
    }
    if (toDate && !fromDate) {
        const to = (0, moment_timezone_1.default)(toDate).toISOString();
        this.andWhere(`${key} <= :to`, { to });
    }
    if (toDate && fromDate) {
        const from = (0, moment_timezone_1.default)(fromDate).toISOString();
        const to = (0, moment_timezone_1.default)(toDate).toISOString();
        this.andWhere(`${key} <= :to AND ${key} > :from`, {
            to,
            from,
        });
    }
    return this;
};
SelectQueryBuilder_1.SelectQueryBuilder.prototype.active = function (key) {
    this.andWhere(`${key}.active = true`);
    return this;
};
//# sourceMappingURL=query.js.map