import * as argon from 'argon2';

export const hash = async (password: string): Promise<string> => {
  try {
    return await argon.hash(password);
  } catch (err) {
    return '0';
  }
};

export const verify = async (
  hashed: string,
  password: string
): Promise<boolean> => {
  try {
    return await argon.verify(hashed, password);
  } catch (err) {
    return false;
  }
};
