import {
  ArgumentsHost,
  Catch,
  ExceptionFilter,
  HttpException,
} from '@nestjs/common';
import { Response } from 'express';

@Catch(HttpException)
export class HttpExceptionFilter implements ExceptionFilter {
  catch(exception: any, host: ArgumentsHost) {
    const ctx = host.switchToHttp();
    const status = exception.getStatus();

    const response = ctx.getResponse<Response>();

    response.status(status).json({
      status: false,
      message: exception.message,
    });
  }
}
