import { DataSource, DataSourceOptions } from 'typeorm';
import { createDatabase, SeederOptions } from 'typeorm-extension';
import { PersonEntity } from './entities/user/person.entity';
import { AgencyEntity } from './entities/user/agency.entity';
import { ConsultantEntity } from './entities/user/consultant.entity';
import { MessageEntity } from './entities/user/message.entity';
import { PlaceEntity } from './entities/place.entity';
import { PlaceInfoEntity } from './entities/place-info.entity';
import { AdminSeeder } from './seeders/admin.seeder';
import { PlaceSeeder } from './seeders/place.seeder';
import { config } from 'dotenv';
import { AdsParams } from './entities/ads-params';
import { Advertise } from './entities/advertise.entity';
import { SaleApartment } from './entities/ads-types/sale-apartment.entity';
import { SaleVilla } from './entities/ads-types/sale-villa.entity';
import { UserEntity } from './entities/user.entity';
import { AgeSeeder } from './seeders/age.seeder';
import { SaleOldHouse } from './entities/ads-types/sale-old-house.entity';
import { Ads } from './entities/ads-types';

config();

const { port =3306, host="localhost", username="khaneha2_users", password="!@#7111375!@#", database="nest_khaneh_db" } = process.env;

const entities = [
  UserEntity,
  PersonEntity,
  AgencyEntity,
  ConsultantEntity,
  MessageEntity,
  PlaceEntity,
  PlaceInfoEntity,
  Advertise,
  ...Ads,
  ...AdsParams,
];

export const options: DataSourceOptions & SeederOptions = {
  type: 'mysql',
  host,
  port: Number(port),
  username,
  password,
  database,
  synchronize: true,
  logging: true,
  charset: 'UTF8_GENERAL_CI',
  entities,
  migrations: [],
  subscribers: [],
  migrationsRun: true,
  seeds: [AdminSeeder, PlaceSeeder, AgeSeeder],
};

export const CreateDatabase = async () =>
  await createDatabase({ options, ifNotExist: true });

export default new DataSource(options);
