import { AfterLoad, BeforeInsert, ChildEntity, Column, ManyToOne } from "typeorm";
import { Age, IAge } from "../ads-params/age.entity";
import { BuildingSide, IBuildingSide } from "../ads-params/builing-side.entity";
import { CabinetType, ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType, ReconstructionType } from "../ads-params/construction.entity";
import { CoolingSystemType, ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { FloorNubmer } from "../ads-params/floor-number.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { HeatingSystemType, IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { HeatWaterSystemType, IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom, Room } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor, UnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IWC, Wc } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
import { IsBoolean, IsNumber } from "class-validator";
import { ApiProperty } from "@nestjs/swagger";

@ChildEntity()
export class RentApartment extends Advertise implements IRentApartment {
  constructor(props?: IRentApartment) {
    super(props)
  }

  @AfterLoad()
  afterLoad() {
    this.mortgageAmount= Number(this.mortgageAmount); 
    this.rentAmount= Number(this.rentAmount); 
  }


  @BeforeInsert()
  updateProps() {
    this.propertyType = 'rent-apratment';
    this.category = 'residence-rent';
  }

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  mortgageAmount?: number;

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  rentAmount?: number;

  @IsBoolean()
  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasAbilityToChange?: boolean;

  @IsNumber()
  @ApiProperty({ example: 100 })
  @Column({default: 0})
  meterage?: number;

  @ApiProperty({ type: 'enum', example: 'penthouse | tower | suite' })
  @Column({ nullable: true, type: 'varchar' })
  buildingType?: 'penthouse' | 'tower' | 'suite';

  @ApiProperty({ type: String, description: 'building age id' })
  @ManyToOne(() => Age, { eager: true })
  age?: Age;

  @ApiProperty({ type: String, description: 'room number' })
  @ManyToOne(() => Room, { eager: true })
  room?: Room;

  @ApiProperty({ type: String })
  @ManyToOne(() => FloorNubmer, { eager: true })
  floorNumber?: FloorNubmer;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGarage?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasElevator?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasStoreHouse?: boolean;

  @ApiProperty({ type: String })
  @ManyToOne(() => TotalFloorType, { eager: true })
  totalFloors?: TotalFloorType;

  @ApiProperty({ type: String })
  @ManyToOne(() => UnitInEachFloor, { eager: true })
  unitInFloor?: UnitInEachFloor;

  @ApiProperty({ example: 20 })
  @Column({ nullable: true })
  totalUnits?: number;

  @ApiProperty({ type: String })
  @ManyToOne(() => BuildingSide, { eager: true })
  buildingSide?: BuildingSide;

  @ApiProperty({type: String})
  @ManyToOne(() => ReconstructionType, { eager: true })
  reconstruct?: ReconstructionType;

  @ApiProperty({ type: String })
  @ManyToOne(() => FlooringMaterialType, { eager: true })
  flooringMaterialType?: FlooringMaterialType;

  @ApiProperty({ type: String })
  @ManyToOne(() => CabinetType, { eager: true })
  cabinetType?: CabinetType;

  @ApiProperty({ type: String })
  @ManyToOne(() => Wc, { eager: true })
  wc?: Wc;

  @ApiProperty({ type: String })
  @ManyToOne(() => CoolingSystemType, { eager: true })
  coolingSystemType?: CoolingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatingSystemType, { eager: true })
  heatingSystemType?: HeatingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatWaterSystemType, { eager: true })
  heatWaterSystemType?: HeatWaterSystemType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCentralAnthena?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasConferenceHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBathTub?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasMasterRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBalcony?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGazebo?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSwimmingPool?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasRoofGarden?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasLobby?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGamingRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSportingHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSaunaJacuzzi?: boolean;
}

export interface IRentApartment extends IAdvertise {
  mortgageAmount?: number;
  rentAmount?: number;
  hasAbilityToChange?: boolean;
  meterage?: number;
  buildingType?: 'penthouse' | 'tower' | 'suite';
  age?: IAge;
  room?: IRoom;
  floorNumber?: FloorNubmer;
  hasGarage?: boolean;
  hasElevator?: boolean;
  hasStoreHouse?: boolean;
  totalFloors?: TotalFloorType;
  unitInFloor?: IUnitInEachFloor;
  totalUnits?: number;
  buildingSide?: IBuildingSide;
  reconstruct?: IReconstructionType;
  flooringMaterialType?: IFlooringMaterialType;
  cabinetType?: ICabinetType;
  wc?: IWC;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;
  hasCentralAnthena?: boolean;
  hasConferenceHall?: boolean;
  hasBathTub?: boolean;
  hasMasterRoom?: boolean;
  hasBalcony?: boolean;
  hasGazebo?: boolean;
  hasSwimmingPool?: boolean;
  hasRoofGarden?: boolean;
  hasLobby?: boolean;
  hasGamingRoom?: boolean;
  hasSportingHall?: boolean;
}