import { AfterLoad, BeforeInsert, ChildEntity, Column, ManyToOne } from 'typeorm';
import { Age, IAge } from '../ads-params/age.entity';
import { BuildingSide, IBuildingSide } from '../ads-params/builing-side.entity';
import { CabinetType, ICabinetType } from '../ads-params/cabinet.entity';
import { CoolingSystemType, ICoolSystemType } from '../ads-params/cool-system-type.entity';
import { BuildingDocType, IBuildingDocType } from '../ads-params/doc.entity';
import { FlooringMaterialType, IFlooringMaterialType } from '../ads-params/flooring-material-type.entity';
import { HeatingSystemType, IHeatingSystemType } from '../ads-params/heat-system-type.entity';
import { HeatWaterSystemType, IHeatWaterSystem } from '../ads-params/heat-water-system.entity';
import { IRoom, Room } from '../ads-params/room.entity';
import { IUnitInEachFloor } from '../ads-params/unit-in-each-floor.enity';
import { IWC, Wc } from '../ads-params/wc.entity';
import { Advertise, IAdvertise } from '../advertise.entity';
import {  IReconstructionType, ReconstructionType} from '../ads-params/construction.entity';
import { ApiProperty } from '@nestjs/swagger';
import { IsBoolean, IsNotEmpty, IsNumber, IsString } from 'class-validator';
import { IVillaTotalFloorType, VillaTotalFloorType } from '../ads-params/villa-total-floor-type.entity';

@ChildEntity()
export class SaleOldHouse extends Advertise implements ISaleOldHouse {
  constructor(props?: ISaleOldHouse) {
    super(props)
  }

  @AfterLoad()
  afterLoad() {
    this.totalPrice = Number(this.totalPrice); 
    this.prepayment = Number(this.prepayment);
    this.installmentAmount= Number(this.installmentAmount);
  }

  @BeforeInsert()
  updateProps() {
    this.propertyType = 'sale-old-house';
    this.category = 'residence-sale';
  }

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty({example: 100000000})
  @Column({type: "bigint", default: 0})
  totalPrice?: number;

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty({example: 100})
  @Column({default: 0})
  landMeterage?: number;

  @IsNumber()
  @ApiProperty({example: 100})
  @Column({default: 0})
  landLength?: number;

  @IsNumber()
  @ApiProperty({example: 100})
  @Column({default: 0})
  landWidth?: number;

  @IsString()
  @ApiProperty({ type: 'enum', example: "'old-house' | 'residence-land'" })
  @Column({ nullable: true, type: 'varchar' })
  buildingType?: 'old-house' | 'residence-land';

  @IsNumber()
  @ApiProperty({example: 100})
  @Column({default: 0})
  buildingMeterage?: number;

  @IsBoolean()
  @ApiProperty()
  @Column({ nullable: true, default: false })
  saleAsInstallment?: boolean;

  @IsNumber()
  @ApiProperty({ nullable: true, example: '30', default: 0 })
  @Column({default: 0})
  prepaymentPercent?: number;

  @ApiProperty({ example: 1000000 })
  @Column({type: "bigint", default: 0})
  prepayment?: number;

  @ApiProperty({ example: 100000 })
  @Column({type: "bigint"})
  installmentAmount?: number;

  @ApiProperty({ example: 12 })
  @Column({default: 0})
  installmentNumber?: number;

  @ApiProperty({ enum: ['zament', 'safteh', 'check'] })
  @Column({ nullable: true, type: 'varchar' })
  installmentPledge?: 'zamen' | 'safteh' | 'check';

  @ApiProperty({ type: String, description: 'building age id' })
  @ManyToOne(() => Age)
  age?: Age;

  @ApiProperty({ type: String, description: 'room number' })
  @ManyToOne(() => Room)
  room?: Room;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGarage?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasStoreHouse?: boolean;

  @ApiProperty({ type: String })
  @ManyToOne(() => BuildingDocType)
  docType: BuildingDocType;

  @ApiProperty({ type: String })
  @ManyToOne(() => VillaTotalFloorType)
  villaTotalFloors: VillaTotalFloorType;

  @ApiProperty({ type: String })
  @ManyToOne(() => BuildingSide)
  buildingSide?: BuildingSide;

  @ApiProperty({type: String})
  @ManyToOne(() => ReconstructionType)
  reconstruct?: ReconstructionType;

  @ApiProperty({ type: String })
  @ManyToOne(() => FlooringMaterialType)
  flooringMaterialType?: FlooringMaterialType;

  @ApiProperty({ type: String })
  @ManyToOne(() => CabinetType)
  cabinetType?: CabinetType;

  @ApiProperty({ type: String })
  @ManyToOne(() => Wc)
  wc?: Wc;

  @ApiProperty({ type: String })
  @ManyToOne(() => CoolingSystemType)
  coolingSystemType?: CoolingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatingSystemType)
  heatingSystemType?: HeatingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatWaterSystemType)
  heatWaterSystemType?: HeatWaterSystemType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCentralAnthena?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasConferenceHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBathTub?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasMasterRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBalcony?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGazebo?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSwimmingPool?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasRoofGarden?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasLobby?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGamingRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSportingHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSaunaJacuzzi?: boolean;
}

export interface ISaleOldHouse extends IAdvertise {
  totalPrice?: number;
  landMeterage?: number;
  landLength?: number;
  landWidth?: number;
  buildingMeterage?: number;
  buildingType?: 'old-house' | 'residence-land';
  saleAsInstallment?: boolean;
  prepaymentPercent?: number | null;
  prepayment?: number | null;
  installmentAmount?: number | null;
  installmentNumber?: number | null;
  installmentPledge?: 'zamen' | 'safteh' | 'check';
  age?: IAge | null;
  room?: IRoom | null;
  hasGarage?: boolean;
  hasStoreHouse?: boolean;
  docType?: IBuildingDocType;
  villaTotalFloors?: IVillaTotalFloorType;
  unitInFloor?: IUnitInEachFloor;
  totalUnits?: number;
  buildingSide?: IBuildingSide;
  reconstruct?: IReconstructionType;
  flooringMaterialType?: IFlooringMaterialType;
  cabinetType?: ICabinetType;
  wc?: IWC;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;
  hasCentralAnthena?: boolean;
  hasConferenceHall?: boolean;
  hasBathTub?: boolean;
  hasMasterRoom?: boolean;
  hasBalcony?: boolean;
  hasGazebo?: boolean;
  hasSwimmingPool?: boolean;
  hasRoofGarden?: boolean;
  hasLobby?: boolean;
  hasGamingRoom?: boolean;
  hasSportingHall?: boolean;
}
