import { AfterLoad, BeforeInsert, ChildEntity, Column, ManyToOne } from "typeorm";
import { Age } from "../ads-params/age.entity";
import { CoolingSystemType, ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { BuildingDocType, IBuildingDocType } from "../ads-params/doc.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { HeatingSystemType, IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { HeatWaterSystemType, IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { Room } from "../ads-params/room.entity";
import { IVillaTotalFloorType, VillaTotalFloorType } from "../ads-params/villa-total-floor-type.entity";
import { IWallMaterialType, WallMaterialType } from "../ads-params/wall-material-type.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsNumber } from "class-validator";

@ChildEntity()
export class SaleStore extends Advertise implements ISaleStore {

  constructor(props?: ISaleStore) {
    super(props);
  }

  @AfterLoad()
  afterLoad() {
    this.totalPrice = Number(this.totalPrice); 
  }

  @BeforeInsert()
  updateProps() {
    this.propertyType = 'sale-store';
    this.category = "commercial-sale";
  }

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  totalPrice?: number;

  @IsNumber()
  @ApiProperty({ example: 100 })
  @Column({default: 0})
  meterage?: number;

  @IsNumber()
  @ApiProperty({ example: 100 })
  @Column({default: 0})
  landMeterage?: number;

  @IsNumber()
  @ApiProperty({ example: 100 })
  @Column({default: 0})
  landLength?: number;

  @IsNumber()
  @ApiProperty({ example: 100 })
  @Column({default: 0})
  landWidth?: number;

  @ApiProperty({ type: 'enum', example: "'farming' | 'niches' | 'workhouse'" })
  @Column({ nullable: true, type: 'varchar' })
  buildingType?: 'farming' | 'niches' | 'workhouse';

  @ApiProperty({ type: String })
  @ManyToOne(() => BuildingDocType, { eager: true })
  docType?: BuildingDocType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  isWorkhosue?: boolean;

  @ApiProperty({ type: String })
  @ManyToOne(() => Age, { eager: true })
  age?: Age;

  @ApiProperty({ type: String })
  @ManyToOne(() => Room, { eager: true })
  room?: Room;

  @ApiProperty({ type: String })
  @ManyToOne(() => VillaTotalFloorType, { eager: true })
  storeTotalFloors?: VillaTotalFloorType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasStoreHouse?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasRoofCrane?: boolean;

  @ApiProperty({ type: String })
  @ManyToOne(() => FlooringMaterialType, { eager: true })
  flooringMaterialType?: FlooringMaterialType;

  @ApiProperty({ type: String })
  @ManyToOne(() => WallMaterialType, { eager: true })
  wallMaterialType?: WallMaterialType;

  @ApiProperty({ type: String })
  @ManyToOne(() => CoolingSystemType, { eager: true })
  coolingSystemType?: ICoolSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatingSystemType, { eager: true })
  heatingSystemType?: IHeatingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatWaterSystemType, { eager: true })
  heatWaterSystemType?: IHeatWaterSystem;


  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasLift?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasShelf?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasAlarm?: boolean

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCCTV?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasElectricShutters?:boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasFireExtinguishing?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSecurityRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasAdministrativeRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasInternetMast?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasDinningSalon?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasWeighbridge?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasWaterWell?: boolean;
}

export interface ISaleStore extends IAdvertise {
  totalPrice?: number;
  meterage?: number;
  landMeterage?: number;
  landLength?: number;
  landWidth?: number;
  buildingType?: 'farming' | 'niches' | 'workhouse';
  docType?: IBuildingDocType;
  isWorkhosue?: boolean;
  age?: Age;
  room?: Room;
  storeTotalFloors?: IVillaTotalFloorType;
  hasStoreHouse?: boolean;
  hasRoofCrane?: boolean;
  flooringMaterialType?: IFlooringMaterialType;
  wallMaterialType?: IWallMaterialType;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;
  hasLift?: boolean;
  hasShelf?: boolean;
  hasAlarm?: boolean
  hasCCTV?: boolean;
  hasElectricShutters?:boolean;
  hasFireExtinguishing?: boolean;
  hasSecurityRoom?: boolean;
  hasAdministrativeRoom?: boolean;
  hasInternetMast?: boolean;
  hasDinningSalon?: boolean;
  hasWeighbridge?: boolean;
  hasWaterWell?: boolean;
}