import { SharedEntity } from './shared.entity';
import { AfterLoad, Column, Entity } from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';

@Entity({ name: 'places-info' })
export class PlaceInfoEntity
  extends SharedEntity<IPlaceInfoEntity>
  implements IPlaceInfoEntity
{
  @ApiProperty()
  @Column({ nullable: true, type: 'text' })
  location?: string;

  @ApiProperty()
  @Column({ nullable: true, type: 'text' })
  polygon?: string;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  isCapitalCounty?: boolean;

  @ApiProperty({ type: Boolean })
  @ApiProperty()
  @Column({ type: 'boolean', default: false })
  canInsertAdvertise: boolean;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  showAdvertise: boolean;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  canInsertSpecialAdvertise: boolean;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  showSpecialAdvertise: boolean;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  canInsertCommercial?: boolean;

  @ApiProperty({ type: Boolean })
  @Column({ type: 'boolean', default: false })
  showCommercial?: boolean;

  @ApiProperty({ type: [String] })
  @Column({ type: 'simple-array', nullable: true })
  closeCities?: string[];

  @AfterLoad()
  afterLoad() {
    super.afterLoad();
    this.polygon = '';
    this.location = '';
  }
}
export interface IPlaceInfoEntity {
  id?: string;

  location?: string;

  polygon?: string;

  isCapitalCounty?: boolean;

  canInsertAdvertise?: boolean;

  showAdvertise?: boolean;

  canInsertSpecialAdvertise?: boolean;

  showSpecialAdvertise?: boolean;

  // بازرگانی
  canInsertCommercial?: boolean;

  showCommercial?: boolean;

  closeCities?: string[];
}
