import { Column, Entity, OneToMany, TableInheritance } from 'typeorm';
import { SharedEntity } from './shared.entity';
import { IMessageEntity, MessageEntity } from './user/message.entity';

@Entity({ name: 'users' })
@TableInheritance({ column: { type: 'varchar', name: 'type' } })
export class UserEntity
  extends SharedEntity<IUserEntity>
  implements IUserEntity
{
  constructor(props?: IUserEntity) {
    super(props);
  }

  @Column({ nullable: true, type: 'varchar', length: 15 })
  cellphone?: string;

  @Column({ nullable: true, type: 'varchar' })
  firstName?: string;

  @Column({ nullable: true, type: 'varchar' })
  lastName?: string;

  @Column({ nullable: true, type: 'varchar', length: 30 })
  userName?: string;

  @Column({ default: false })
  isSystemUser?: boolean;

  @Column({
    type: 'enum',
    enum: ['personal', 'agency', 'consultant', 'none'],
    default: 'none',
  })
  subscriberType?: 'personal' | 'agency' | 'consultant' | 'none';

  @OneToMany(() => MessageEntity, (m) => m.user)
  messages?: IMessageEntity[];

  @Column({ nullable: true, type: 'varchar', length: 512, select: false })
  password?: string;

  type?: string;
}

export interface IUserEntity {
  cellphone?: string;

  isSystemUser?: boolean;

  subscriberType?: 'personal' | 'agency' | 'consultant' | 'none';

  firstLogin?: boolean;

  password?: string;

  firstName?: string;

  lastName?: string;

  userName?: string;

  type?: string;

  messages?: IMessageEntity[];
}
