import { ChildEntity, Column, JoinTable, ManyToMany, ManyToOne } from 'typeorm';
import { IUserEntity, UserEntity } from '../user.entity';
import { IPlaceEntity, PlaceEntity } from '../place.entity';

@ChildEntity()
export class AgencyEntity extends UserEntity implements IAgencyEntity {
  constructor(props?: IAgencyEntity) {
    super(props);
    this.subscriberType = 'agency';
  }

  @Column()
  title?: string;

  @Column()
  cityCode?: string;

  @Column()
  phoneNumber?: string;

  @Column()
  licenseNumber?: string;

  @Column()
  licenseImg?: string;

  @Column({ nullable: true, type: 'json' })
  address?: object;

  @ManyToOne(() => PlaceEntity)
  city?: IPlaceEntity;

  @ManyToMany(() => PlaceEntity, (p) => p.agencies)
  @JoinTable()
  areas?: IPlaceEntity[];
}

export interface IAgencyEntity extends IUserEntity {
  title?: string;

  cityCode?: string;

  phoneNumber?: string;

  licenseNumber?: string;

  licenseImg?: string;

  address?: any;

  city?: IPlaceEntity;

  areas?: IPlaceEntity[];
}
