import { DataSource } from 'typeorm';
import { Seeder } from 'typeorm-extension';
import { PlaceType } from './places/type';
import { azarbyjan_sharghi } from './places/azarbayjan_sharghi';
import { azarbayjan_gharbi } from './places/azarbayjan_gharbi';
import { PlaceInfoEntity } from '../entities/place-info.entity';
import { PlaceEntity } from '../entities/place.entity';

export class PlaceSeeder implements Seeder {
  province: PlaceType[] = [azarbyjan_sharghi, azarbayjan_gharbi];
  async run(dataSource: DataSource): Promise<any> {
    const places = dataSource.getRepository(PlaceEntity);

    const p = await places.find();

    if (p.length === 0) {
      const iranInfo = new PlaceInfoEntity({
        showAdvertise: true,
        isCapitalCounty: false,
        canInsertAdvertise: false,
        canInsertSpecialAdvertise: false,
        canInsertCommercial: false,
        showSpecialAdvertise: true,
        showCommercial: true,
        closeCities: [],
      });

      await iranInfo.save();

      const iran = new PlaceEntity({
        name: 'ایران',
        eName: 'iran',
        type: 'country',
      });

      iran.info = iranInfo;

      await iran.save();

      for (let province of this.province) {
        const provInfo = new PlaceInfoEntity({
          ...province,
          closeCities: [],
        });
        await provInfo.save();

        const prov = new PlaceEntity({
          type: 'province',
          eName: province.eName,
          name: province.name,
          parent: iran,
        });
        prov.info = provInfo;
        await prov.save();

        for (let city of province.children) {
          const cityInfo = new PlaceInfoEntity({
            ...city,
            closeCities: [],
          });
          await cityInfo.save();

          const _city = new PlaceEntity({
            type: 'city',
            eName: city.eName,
            name: city.name,
            parent: prov,
          });
          _city.info = cityInfo;
          await _city.save();
        }
      }
    }
  }
}
