import { CallHandler, ExecutionContext, NestInterceptor } from '@nestjs/common';
import { Observable, map, tap } from 'rxjs';

export class AdversInterceptor implements NestInterceptor {
  intercept(
    context: ExecutionContext,
    next: CallHandler<any>
  ): Observable<any> | Promise<Observable<any>> {
    return next
      .handle()
      .pipe(
        map((x: any) => this._modify(x))
      );
  }

  private _modify(x: any) {
    const {city, district, createdAt, updatedAt, images, ...rest} = x || {};

    const keys = ["age", "room", "docType", "totalFloors", "buildingSide", "reconstruct", "flooringMaterialType", "unitInFloor",
    "cabinetType",
    "wc",
    "coolingSystemType",
    "heatingSystemType",
    "heatWaterSystemType",
    "villaTotalFloors"
   ];

    let response = {
      ...rest,
      cityId: city?.id,
      districtId: district?.id,
      images: images? images: []
    };

    keys.map(k => {
      console.log('key: ',k);
      if(response[k] && response[k] !== null) {
      console.log('value: ', response[k]);
        response[k] = response[k].id;
      } 

    })

    for(let item in keys) {
    }

    return response;
  }
}
