import { Controller, Get, Query } from '@nestjs/common';
import { QueryBus } from '@nestjs/cqrs';
import { ApiTags } from '@nestjs/swagger';
import { GetAdvertiseList } from './queries/GetAdvertiseList';

@ApiTags('Advertise')
@Controller('advertise')
export class BaseAdvertiseController {
  constructor(private readonly queryBus: QueryBus) {}

  @Get('')
  getAdvertiseList(@Query() query: any) {
    return this.queryBus.execute(new GetAdvertiseList(query));
  }
}
