import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import repositories from '~db/repositories';
import { SMSService } from '~modules/auth/sms.service';
import { LoginDto } from '~modules/auth/models/login';
import { IUserEntity, UserEntity } from '~db/entities/user.entity';
import { MessageEntity } from '~db/entities/user/message.entity';

const { users, messages } = repositories;

export class LoginCommand {
  constructor(public props: LoginDto) {}
}

@CommandHandler(LoginCommand)
export class LoginHandler implements ICommandHandler<LoginCommand> {
  constructor(private readonly sms: SMSService) {}

  async execute(command: LoginCommand): Promise<any> {
    const { cellphone } = command.props;

    const code = `${Math.floor(Math.random() * 99999)}`;

    const message = new MessageEntity({ code });

    let user: UserEntity = await users.findOneBy({ cellphone });

    if (!user) {
      user = new UserEntity({ cellphone, isSystemUser: false } as IUserEntity);
      await user.save();
    }
    message.user = user;
    await message.save();
    this.sms.send(cellphone, code);
    return 'done';
  }
}
