import { Body, Controller, Delete, Get, Param, Post } from '@nestjs/common';
import { ApiBody, ApiOkResponse, ApiProperty, ApiTags } from '@nestjs/swagger';
import { CurdService } from './crud.service';

export function GenericControllerMixin<T>(
  entityClass: new () => T,
  path?: string
) {
  const tagName = entityClass.name;

  class ListResponse {
    @ApiProperty()
    status: boolean;

    @ApiProperty({ type: [entityClass] })
    data: any[];
  }

  @ApiTags(tagName.split(/\.?(?=[A-Z])/).join(' '))
  class GenericController {
    constructor(public readonly srv: CurdService<T>) {}
    @Get()
    @ApiOkResponse({ type: ListResponse })
    async list() {
      return await this.srv.list(tagName);
    }

    @Get(':id')
    async signle(@Param('id') id: string) {
      return await this.srv.single(tagName, id);
    }

    @Post()
    @ApiBody({ type: entityClass })
    async upsert(@Body() dto: T) {
      return await this.srv.upsert(tagName, dto);
    }

    @Delete(':id')
    async remove(@Param('id') id: string) {
      return await this.srv.remove(tagName, id);
    }
  }

  Controller(`base/${path}`)(GenericController);
  return GenericController;
}
