import { Injectable } from '@nestjs/common';
import { db } from '../../../db/repositories';
import { HandledError } from '~core/classes/handled-error';
import dict from '~constants/dict';

@Injectable()
export class CurdService<T> {
  async list(entityName: string): Promise<any[]> {
    const repo = db.getRepository(entityName);
    const list = await repo.find();

    return list;
  }

  async upsert(entityName: string, entity: any) {
    const { id, ...rest } = entity || {};

    const repo = await db.getRepository(entityName);

    if (id) {
      //update
      let item = await repo.findOneBy({ id });
      if (!item) throw new HandledError(dict.RECORDE_DOES_NOT_EkXIST);

      item.update(rest);
      await item.save();
      return item;
    } else {
      //insert
      const item = await repo.save(rest);
      return item;
    }
  }

  async single(entityName: string, id: string) {
    const repo = await db.getRepository(entityName);

    const item = await repo.findOneBy({ id });

    if (!item) throw new HandledError(dict.RECORDE_DOES_NOT_EkXIST);

    return item;
  }

  async remove(entityName: string, id: string) {
    const repo = await db.getRepository(entityName);

    const item = await repo.findOneBy({ id });

    if (!item) throw new HandledError(dict.RECORDE_DOES_NOT_EkXIST);

    await item.softRemove();

    return dict.SUCCESS_MESSAGE;
  }
}
