import { Controller, Get, Query } from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { AxiosService } from '~core/axios';
import { GeocodingQuery, ReverseQuery } from './map.model';
import { HttpService } from '@nestjs/axios';
import { catchError, firstValueFrom, map } from 'rxjs';

@ApiTags('Map')
@Controller('map')
export class MapController {
  constructor(private readonly http: HttpService) {}

  @Get('search')
  search() {}

  @Get('reverse')
  async reverse(@Query() params: ReverseQuery) {
    const res = await firstValueFrom(
      this.http.get(`/v5/reverse`, { params }).pipe(
        map((x) => x.data),
        catchError((err) => {
          throw 'error happend';
        })
      )
    );
    return res;
  }

  @Get('geocoding')
  async geocoding(@Query() params: GeocodingQuery) {
    const res = await firstValueFrom(
      this.http.get(`v4/geocoding`, { params }).pipe(
        map((x) => x.data),
        catchError((err) => {
          throw 'error happend';
        })
      )
    );
    return res;
  }
}
