import { Module } from '@nestjs/common';
import { CqrsModule } from '@nestjs/cqrs';
import { UserController } from './user.controller';
import { AdminUserController } from './admin-user.controller';
import {
  GetCurrentUserHandler,
  GetUserListHandler,
  UpsertAgencyUserHandler,
  UpsertConsultantHandler,
  UpsertPersonalUserHandler,
  UpsertSystemHandler,
} from '~modules/users/handlers';

@Module({
  imports: [CqrsModule],
  controllers: [UserController, AdminUserController],
  providers: [
    GetUserListHandler,
    GetCurrentUserHandler,
    UpsertSystemHandler,
    UpsertAgencyUserHandler,
    UpsertPersonalUserHandler,
    UpsertConsultantHandler,
  ],
})
export class UserModule {}
