"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatDate = exports.localTime = exports.localDate = void 0;
const moment = require("moment-timezone");
const jalali = require("jalali-moment");
const localDate = (d, format) => {
    return jalali(d).locale('fa').format('YYYY/MM/DD');
};
exports.localDate = localDate;
const localTime = (d) => {
    return moment(d).tz('Asia/Tehran').format('HH:mm');
};
exports.localTime = localTime;
const formatDate = (d) => {
    return moment(d).locale('fa').format('YYYY/MM/DD HH:mm');
};
exports.formatDate = formatDate;
//# sourceMappingURL=datetime.js.map