"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const typeorm_extension_1 = require("typeorm-extension");
const ds_1 = require("./ds");
class Db {
    constructor() { }
    static get instance() {
        return this._db;
    }
    static get status() {
        return this._status;
    }
    static set status(value) {
        this._status = value;
    }
    static async connect() {
        try {
            await (0, ds_1.CreateDatabase)();
            await ds_1.default.initialize();
            await (0, typeorm_extension_1.runSeeders)(ds_1.default);
            this.status = true;
        }
        catch (err) {
            console.log(err);
            this.status = false;
        }
    }
    static async seed() { }
    get ds() {
        return ds_1.default;
    }
}
Db._db = new Db();
exports.default = Db;
//# sourceMappingURL=db.js.map