import { Age, IAge } from "../ads-params/age.entity";
import { BuildingSide, IBuildingSide } from "../ads-params/builing-side.entity";
import { CabinetType, ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType, ReconstructionType } from "../ads-params/construction.entity";
import { CoolingSystemType, ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { HeatingSystemType, IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { HeatWaterSystemType, IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom, Room } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IVillaTotalFloorType, VillaTotalFloorType } from "../ads-params/villa-total-floor-type.entity";
import { IWC, Wc } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
export declare class RentVilla extends Advertise implements IAdvertise {
    constructor(props?: IRentVilla);
    afterLoad(): void;
    updateProps(): void;
    mortgageAmount?: number;
    rentAmount?: number;
    hasAbilityToChange?: boolean;
    buildingType?: 'villa-garden' | 'garden' | 'villa';
    landMeterage?: number;
    buildingMeterage?: number;
    age?: Age;
    room: Room;
    hasGarage?: boolean;
    hasStoreHouse?: boolean;
    villaTotalFloors: VillaTotalFloorType;
    buildingSide?: BuildingSide;
    reconstruct?: ReconstructionType;
    flooringMaterialType?: FlooringMaterialType;
    cabinetType?: CabinetType;
    wc?: Wc;
    coolingSystemType?: CoolingSystemType;
    heatingSystemType?: HeatingSystemType;
    heatWaterSystemType?: HeatWaterSystemType;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
    hasSaunaJacuzzi?: boolean;
}
export interface IRentVilla extends IAdvertise {
    mortgageAmount?: number;
    rentAmount?: number;
    hasAbilityToChange?: number;
    landMeterage?: number;
    buildingMeterage?: number;
    villaTotalFloors?: IVillaTotalFloorType;
    buildingType?: 'villa-garden' | 'garden' | 'villa';
    age?: IAge;
    room?: IRoom;
    hasGarage?: boolean;
    hasStoreHouse?: boolean;
    totalFloors?: TotalFloorType;
    unitInFloor?: IUnitInEachFloor;
    totalUnits?: number;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
}
