import { Age, IAge } from '../ads-params/age.entity';
import { BuildingSide, IBuildingSide } from '../ads-params/builing-side.entity';
import { CabinetType, ICabinetType } from '../ads-params/cabinet.entity';
import { CoolingSystemType, ICoolSystemType } from '../ads-params/cool-system-type.entity';
import { BuildingDocType, IBuildingDocType } from '../ads-params/doc.entity';
import { HeatingSystemType, IHeatingSystemType } from '../ads-params/heat-system-type.entity';
import { HeatWaterSystemType, IHeatWaterSystem } from '../ads-params/heat-water-system.entity';
import { IRoom, Room } from '../ads-params/room.entity';
import { IUnitInEachFloor, UnitInEachFloor } from '../ads-params/unit-in-each-floor.enity';
import { IWC, Wc } from '../ads-params/wc.entity';
import { Advertise, IAdvertise } from '../advertise.entity';
import { FlooringMaterialType, IFlooringMaterialType } from '../ads-params/flooring-material-type.entity';
import { FloorNubmer } from '../ads-params/floor-number.entity';
import { ReconstructionType, IReconstructionType } from '../ads-params/construction.entity';
import { TotalFloorType } from '../ads-params/total-floor-type.entity';
export declare class SaleApartment extends Advertise implements ISaleApartment {
    constructor(props?: ISaleApartment);
    afterLoad(): void;
    updateProps(): void;
    totalPrice?: number;
    meterage?: number;
    buildingType?: 'penthouse' | 'tower' | 'suite';
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    hasLoan?: boolean;
    totalLoanAmount?: number;
    loanInstallmentAmount?: number;
    loanInstallmentNumber?: number;
    age?: Age;
    room?: Room;
    floorNumber?: FloorNubmer;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    docType?: BuildingDocType;
    totalFloors?: TotalFloorType;
    unitInFloor?: UnitInEachFloor;
    totalUnits?: number;
    buildingSide?: BuildingSide;
    reconstruct?: ReconstructionType;
    flooringMaterialType?: FlooringMaterialType;
    cabinetType?: CabinetType;
    wc?: Wc;
    coolingSystemType?: CoolingSystemType;
    heatingSystemType?: HeatingSystemType;
    heatWaterSystemType?: HeatWaterSystemType;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
    hasSaunaJacuzzi?: boolean;
}
export interface ISaleApartment extends IAdvertise {
    totalPrice?: number;
    meterage?: number;
    buildingType?: 'penthouse' | 'tower' | 'suite';
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    hasLoan?: boolean;
    totalLoanAmount?: number;
    loanInstallmentAmount?: number;
    loanInstallmentNumber?: number;
    age?: IAge;
    room?: IRoom;
    floorNumber?: FloorNubmer;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    docType?: IBuildingDocType;
    totalFloors?: TotalFloorType;
    unitInFloor?: IUnitInEachFloor;
    totalUnits?: number;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
}
