"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaleOldHouse = void 0;
const typeorm_1 = require("typeorm");
const age_entity_1 = require("../ads-params/age.entity");
const builing_side_entity_1 = require("../ads-params/builing-side.entity");
const cabinet_entity_1 = require("../ads-params/cabinet.entity");
const cool_system_type_entity_1 = require("../ads-params/cool-system-type.entity");
const doc_entity_1 = require("../ads-params/doc.entity");
const flooring_material_type_entity_1 = require("../ads-params/flooring-material-type.entity");
const heat_system_type_entity_1 = require("../ads-params/heat-system-type.entity");
const heat_water_system_entity_1 = require("../ads-params/heat-water-system.entity");
const room_entity_1 = require("../ads-params/room.entity");
const wc_entity_1 = require("../ads-params/wc.entity");
const advertise_entity_1 = require("../advertise.entity");
const construction_entity_1 = require("../ads-params/construction.entity");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const villa_total_floor_type_entity_1 = require("../ads-params/villa-total-floor-type.entity");
let SaleOldHouse = class SaleOldHouse extends advertise_entity_1.Advertise {
    constructor(props) {
        super(props);
    }
    afterLoad() {
        this.totalPrice = Number(this.totalPrice);
        this.prepayment = Number(this.prepayment);
        this.installmentAmount = Number(this.installmentAmount);
    }
    updateProps() {
        this.propertyType = 'sale-old-house';
        this.category = 'residence-sale';
    }
};
exports.SaleOldHouse = SaleOldHouse;
__decorate([
    (0, typeorm_1.AfterLoad)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SaleOldHouse.prototype, "afterLoad", null);
__decorate([
    (0, typeorm_1.BeforeInsert)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SaleOldHouse.prototype, "updateProps", null);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100000000 }),
    (0, typeorm_1.Column)({ type: "bigint", default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "totalPrice", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "landMeterage", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "landLength", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "landWidth", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'enum', example: "'old-house' | 'residence-land'" }),
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], SaleOldHouse.prototype, "buildingType", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "buildingMeterage", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "saleAsInstallment", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ nullable: true, example: '30', default: 0 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "prepaymentPercent", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1000000 }),
    (0, typeorm_1.Column)({ type: "bigint", default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "prepayment", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 100000 }),
    (0, typeorm_1.Column)({ type: "bigint" }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "installmentAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 12 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleOldHouse.prototype, "installmentNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: ['zament', 'safteh', 'check'] }),
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], SaleOldHouse.prototype, "installmentPledge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String, description: 'building age id' }),
    (0, typeorm_1.ManyToOne)(() => age_entity_1.Age),
    __metadata("design:type", age_entity_1.Age)
], SaleOldHouse.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String, description: 'room number' }),
    (0, typeorm_1.ManyToOne)(() => room_entity_1.Room),
    __metadata("design:type", room_entity_1.Room)
], SaleOldHouse.prototype, "room", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasGarage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasStoreHouse", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => doc_entity_1.BuildingDocType),
    __metadata("design:type", doc_entity_1.BuildingDocType)
], SaleOldHouse.prototype, "docType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => villa_total_floor_type_entity_1.VillaTotalFloorType),
    __metadata("design:type", villa_total_floor_type_entity_1.VillaTotalFloorType)
], SaleOldHouse.prototype, "villaTotalFloors", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => builing_side_entity_1.BuildingSide),
    __metadata("design:type", builing_side_entity_1.BuildingSide)
], SaleOldHouse.prototype, "buildingSide", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => construction_entity_1.ReconstructionType),
    __metadata("design:type", construction_entity_1.ReconstructionType)
], SaleOldHouse.prototype, "reconstruct", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => flooring_material_type_entity_1.FlooringMaterialType),
    __metadata("design:type", flooring_material_type_entity_1.FlooringMaterialType)
], SaleOldHouse.prototype, "flooringMaterialType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => cabinet_entity_1.CabinetType),
    __metadata("design:type", cabinet_entity_1.CabinetType)
], SaleOldHouse.prototype, "cabinetType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => wc_entity_1.Wc),
    __metadata("design:type", wc_entity_1.Wc)
], SaleOldHouse.prototype, "wc", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => cool_system_type_entity_1.CoolingSystemType),
    __metadata("design:type", cool_system_type_entity_1.CoolingSystemType)
], SaleOldHouse.prototype, "coolingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_system_type_entity_1.HeatingSystemType),
    __metadata("design:type", heat_system_type_entity_1.HeatingSystemType)
], SaleOldHouse.prototype, "heatingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_water_system_entity_1.HeatWaterSystemType),
    __metadata("design:type", heat_water_system_entity_1.HeatWaterSystemType)
], SaleOldHouse.prototype, "heatWaterSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasCentralAnthena", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasConferenceHall", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasBathTub", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasMasterRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasBalcony", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasGazebo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasSwimmingPool", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasRoofGarden", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasLobby", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasGamingRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasSportingHall", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleOldHouse.prototype, "hasSaunaJacuzzi", void 0);
exports.SaleOldHouse = SaleOldHouse = __decorate([
    (0, typeorm_1.ChildEntity)(),
    __metadata("design:paramtypes", [Object])
], SaleOldHouse);
//# sourceMappingURL=sale-old-house.entity.js.map