"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaceSeeder = void 0;
const azarbayjan_sharghi_1 = require("./places/azarbayjan_sharghi");
const azarbayjan_gharbi_1 = require("./places/azarbayjan_gharbi");
const place_info_entity_1 = require("../entities/place-info.entity");
const place_entity_1 = require("../entities/place.entity");
class PlaceSeeder {
    constructor() {
        this.province = [azarbayjan_sharghi_1.azarbyjan_sharghi, azarbayjan_gharbi_1.azarbayjan_gharbi];
    }
    async run(dataSource) {
        const places = dataSource.getRepository(place_entity_1.PlaceEntity);
        const p = await places.find();
        if (p.length === 0) {
            const iranInfo = new place_info_entity_1.PlaceInfoEntity({
                showAdvertise: true,
                isCapitalCounty: false,
                canInsertAdvertise: false,
                canInsertSpecialAdvertise: false,
                canInsertCommercial: false,
                showSpecialAdvertise: true,
                showCommercial: true,
                closeCities: [],
            });
            await iranInfo.save();
            const iran = new place_entity_1.PlaceEntity({
                name: 'ایران',
                eName: 'iran',
                type: 'country',
            });
            iran.info = iranInfo;
            await iran.save();
            for (let province of this.province) {
                const provInfo = new place_info_entity_1.PlaceInfoEntity({
                    ...province,
                    closeCities: [],
                });
                await provInfo.save();
                const prov = new place_entity_1.PlaceEntity({
                    type: 'province',
                    eName: province.eName,
                    name: province.name,
                    parent: iran,
                });
                prov.info = provInfo;
                await prov.save();
                for (let city of province.children) {
                    const cityInfo = new place_info_entity_1.PlaceInfoEntity({
                        ...city,
                        closeCities: [],
                    });
                    await cityInfo.save();
                    const _city = new place_entity_1.PlaceEntity({
                        type: 'city',
                        eName: city.eName,
                        name: city.name,
                        parent: prov,
                    });
                    _city.info = cityInfo;
                    await _city.save();
                }
            }
        }
    }
}
exports.PlaceSeeder = PlaceSeeder;
//# sourceMappingURL=place.seeder.js.map