"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdvertisService = void 0;
const common_1 = require("@nestjs/common");
const dict_1 = require("../../constants/dict");
const handled_error_1 = require("../../core/classes/handled-error");
const repositories_1 = require("../../db/repositories");
let AdvertisService = class AdvertisService {
    async list(tagName, _query, user) {
        const { offset = 1, size = 10 } = _query || {};
        const tag = tagName
            .split(/\.?(?=[A-Z])/)
            .join(' ')
            .toLocaleString()
            .split(' ')[0];
        const repo = await repositories_1.db.getRepository(tagName);
        let query = repo
            .createQueryBuilder(tag)
            .leftJoinAndSelect(`${tag}.advertizer`, 'advertizer')
            .where('advertizer.id = :id', { id: user.id });
        let [list, total] = await Promise.all([
            query.paginate({ offset, size }).getMany(),
            query.getCount(),
        ]);
        return list;
    }
    async single(tagName, id) {
        const repo = await repositories_1.db.getRepository(tagName);
        const item = await repo.findOneBy({ id });
        if (!item)
            throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
        return item;
    }
    async upsert(tagName, dto, user) {
        const { id, ...rest } = dto || {};
        const repo = await repositories_1.db.getRepository(tagName);
        if (id) {
            let item = await repo.findOneBy({ id });
            if (!item)
                throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
            item.update({ ...rest });
            await item.save();
        }
        else {
            const item = await repo.save({ ...rest, advertizer: user });
        }
        return dict_1.default.SUCCESS_MESSAGE;
    }
    async remove(tagName, id) {
        const repo = await repositories_1.db.getRepository(tagName);
        const item = await repo.findOneBy({ id });
        if (!item)
            throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
        await item.softRemove();
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.AdvertisService = AdvertisService;
exports.AdvertisService = AdvertisService = __decorate([
    (0, common_1.Injectable)()
], AdvertisService);
//# sourceMappingURL=advers.service.js.map