import { IPlaceEntity, PlacesType } from '~db/entities/place.entity';
import { IPlaceInfoEntity } from '~db/entities/place-info.entity';
import { ICommandHandler } from '@nestjs/cqrs';
export declare class UpsertPlaceCommand {
    data: UpsertPlaceRequest;
    constructor(data: UpsertPlaceRequest);
}
export declare class UpsertPlaceHandler implements ICommandHandler<UpsertPlaceCommand> {
    execute({ data }: UpsertPlaceCommand): Promise<any>;
}
export declare class UpsertPlaceRequest implements Omit<IPlaceEntity, 'parent'>, IPlaceInfoEntity {
    id: string;
    parent: string;
    name: string;
    eName: string;
    type: PlacesType;
    canInsertAdvertise: boolean;
    canInsertCommercial: boolean;
    canInsertSpecialAdvertise: boolean;
    closeCities: string[];
    isCapitalCounty: boolean;
    location: string;
    polygon: string;
    showAdvertise: boolean;
    showCommercial: boolean;
    showSpecialAdvertise: boolean;
}
