"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectController = void 0;
const swagger_1 = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const project_service_1 = require("./services/project.service");
let ProjectController = class ProjectController {
    constructor(pService) {
        this.pService = pService;
    }
    async getProjectList() {
        return await this.pService.list();
    }
    getProjectContent(id) {
        return this.pService.content(id);
    }
    getProjectData(title) {
        return this.pService.projectData(title);
    }
    getSalesCondition(id) {
        return this.pService.salesCondition(id);
    }
    sendConsultantForm(data) {
        return this.pService.sendConsultForm(data);
    }
    getProjectTypes(code) {
        return this.pService.getProjectType(code);
    }
};
exports.ProjectController = ProjectController;
__decorate([
    (0, common_1.Get)(''),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 418',
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProjectController.prototype, "getProjectList", null);
__decorate([
    (0, common_1.Get)('content/:id'),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 334',
    }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProjectController.prototype, "getProjectContent", null);
__decorate([
    (0, common_1.Get)('/:title'),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 1950',
    }),
    __param(0, (0, common_1.Param)('title')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProjectController.prototype, "getProjectData", null);
__decorate([
    (0, common_1.Get)('sales-condition/:id'),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 1949',
    }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProjectController.prototype, "getSalesCondition", null);
__decorate([
    (0, common_1.Post)('consult'),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 371',
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], ProjectController.prototype, "sendConsultantForm", null);
__decorate([
    (0, common_1.Get)('project-types/:code'),
    (0, swagger_1.ApiOkResponse)({
        description: 'address: 1948',
    }),
    __param(0, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProjectController.prototype, "getProjectTypes", null);
exports.ProjectController = ProjectController = __decorate([
    (0, swagger_1.ApiTags)('Projects'),
    (0, common_1.Controller)('projects'),
    __metadata("design:paramtypes", [project_service_1.ProjectService])
], ProjectController);
//# sourceMappingURL=project.controller.js.map