"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("../../../core/axios");
const NEW_ADDRESS = 'new_address';
let ProjectService = class ProjectService {
    constructor(axios) {
        this.axios = axios;
        this.categoryTypeTitle = [
            {
                category: '1',
                title: '3D نمای خارجی',
            },
            {
                category: '2',
                title: '3D نمای داخلی',
            },
            {
                category: '3',
                title: '',
            },
            {
                category: '6',
                title: 'پلان معماری',
            },
            {
                category: '4',
                title: 'سازه',
            },
            {
                category: '5',
                title: '',
            },
            {
                category: '7',
                title: 'سایت پلان',
            },
            {
                category: '8',
                title: 'جزییات فنی',
            },
            {
                category: '9',
                title: 'شیت معماری',
            },
        ];
    }
    async list() {
        const { result = [] } = await this.axios.oldServer.post('new_address', {
            address: 418,
        });
        return result.map((x) => ({
            ...x,
            thumbnail: `${x?.projectSiteLogo}/${x?.projectLogo}`,
            url: `/pr/${x.projectUrl}`,
        }));
    }
    async content(id) {
        const { result = [] } = await this.axios.oldServer.post('new_address', {
            address: 334,
            id,
        });
        return result[0];
    }
    async projectData(title) {
        const { result = [] } = await this.axios.oldServer.post(NEW_ADDRESS, {
            address: 1950,
            id: title,
        });
        const res = result.map((x) => ({
            ...x,
            thumbnail: `${x.projectSiteLogo}/${x.projectLogo2}`,
        }))[0];
        return res;
    }
    async salesCondition(id) {
        const { result = [] } = await this.axios.oldServer.post(NEW_ADDRESS, {
            address: 1949,
            project: id,
        });
        return result;
    }
    async sendConsultForm(data) {
        const { result = [] } = await this.axios.oldServer.post(NEW_ADDRESS, {
            address: 371,
            ...data,
        });
        return result;
    }
    async getProjectType(code) {
        const { result = [], projectTitle, category, } = await this.axios.oldServer.post(NEW_ADDRESS, {
            address: 1948,
            code,
        });
        console.log({ result });
        const res = {
            title: projectTitle,
            types: [],
        };
        result.forEach((item) => {
            const index = res.types.findIndex((x) => category === item.tipAttachCate);
            if (index !== -1) {
                res.types[index].images.push(`${item.tipAttachSite}/${item.tipAttachName}`);
            }
            else {
                const title = this.categoryTypeTitle?.find((x) => x.category === item.tipAttachCate)?.title;
                const newItem = {
                    title: title,
                    category: item.tipAttachCate,
                    images: [`${item.tipAttachSite}/${item.tipAttachName}`],
                };
                res.types.push(newItem);
            }
        });
        console.log({ res });
        return res;
    }
};
exports.ProjectService = ProjectService;
exports.ProjectService = ProjectService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_1.AxiosService])
], ProjectService);
//# sourceMappingURL=project.service.js.map