"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImgUploadConfigMaker = void 0;
const common_1 = require("@nestjs/common");
const dict_1 = require("../../../constants/dict");
const path = require("path");
const multer_1 = require("multer");
const ImageFileFilter = (req, file, callback) => {
    if (!file.originalname.match(/\.(jpg|jpeg|png|pdf|PNG|JPG|JPEG|PDF)$/)) {
        const err = new common_1.UnsupportedMediaTypeException(dict_1.default.FILE_SHOULD_BE_IMAGE_ERROR_MESSAGE);
        return callback(err, false);
    }
    callback(null, true);
};
const ImgUploadConfigMaker = (key) => {
    return ({
        storage: (0, multer_1.diskStorage)({
            destination: `../uploads/${key}`,
            filename: (req, file, cb) => {
                const randomName = Array(20)
                    .fill(null)
                    .map(() => Math.round(Math.random() * 16).toString(16))
                    .join('');
                cb(null, `${key}-${randomName}${path.extname(file.originalname)}`);
            },
        }),
        fileFilter: ImageFileFilter
    });
};
exports.ImgUploadConfigMaker = ImgUploadConfigMaker;
//# sourceMappingURL=img-uplod.config.js.map