"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetCurrentUserHandler = exports.GetCurrentUserQuery = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const { users } = repositories_1.default;
class GetCurrentUserQuery {
    constructor(user) {
        this.user = user;
    }
}
exports.GetCurrentUserQuery = GetCurrentUserQuery;
let GetCurrentUserHandler = class GetCurrentUserHandler {
    async execute(props) {
        const { user } = props;
        const current = await users
            .createQueryBuilder('user')
            .leftJoinAndSelect('agency.city', 'city')
            .leftJoinAndSelect('agency.areas', 'areas')
            .leftJoinAndSelect('user.system', 'system')
            .select(['user'])
            .where('user.id = :id', { id: user.id })
            .getOne();
        delete current.password;
        return current;
    }
};
exports.GetCurrentUserHandler = GetCurrentUserHandler;
exports.GetCurrentUserHandler = GetCurrentUserHandler = __decorate([
    (0, cqrs_1.QueryHandler)(GetCurrentUserQuery)
], GetCurrentUserHandler);
//# sourceMappingURL=GetCurrentUserQuery.js.map