"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserListHandler = exports.GetUserListQuery = exports.GetUserListDto = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const query_1 = require("../../../../model/query");
const repositories_1 = require("../../../../db/repositories");
const swagger_1 = require("@nestjs/swagger");
const { users } = repositories_1.default;
class GetUserListDto extends query_1.QueryModel {
}
exports.GetUserListDto = GetUserListDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        enum: ['system', 'subscriber'],
        default: 'subscriber',
    }),
    __metadata("design:type", String)
], GetUserListDto.prototype, "type", void 0);
class GetUserListQuery {
    constructor(dto) {
        this.dto = dto;
    }
}
exports.GetUserListQuery = GetUserListQuery;
let GetUserListHandler = class GetUserListHandler {
    async execute(props) {
        const { offset = 1, size = 10, type = 'subscriber' } = props.dto;
        const query = users
            .createQueryBuilder('user')
            .leftJoinAndSelect('agency.city', 'city')
            .leftJoinAndSelect('agency.areas', 'areas')
            .select(['user'])
            .where('user.type = :type', { type });
        let [list, total] = await Promise.all([
            query.paginate({ offset, size }).getMany(),
            query.getCount(),
        ]);
        list = list.map((x) => {
            delete x?.password;
            return x;
        });
        return {
            total,
            list,
        };
    }
};
exports.GetUserListHandler = GetUserListHandler;
exports.GetUserListHandler = GetUserListHandler = __decorate([
    (0, cqrs_1.QueryHandler)(GetUserListQuery)
], GetUserListHandler);
//# sourceMappingURL=GetUserListQuery.js.map