import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { UserModule } from '~modules/users/user.module';
import { AuthModule } from '~modules/auth/auth.module';
import { UploadModule } from '~modules/upload/upload.module';
import { LoggerMiddleware } from '~core/middlewares/logger.middleware';
import { PlaceModule } from '~modules/place/place.module';
import { ProjectModule } from '~modules/projects/project.module';
import { CoreModule } from '~core/core.module';
import { ConfigModule } from '@nestjs/config';
import { MapModule } from '~modules/map/map.module';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { BaseModule } from '~modules/base';
import { AdvertiseModule } from '~modules/advertise/advertise.module';

@Module({
  imports: [
    ConfigModule.forRoot(),
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', 'uploads'),
    }),
    AuthModule,
    UserModule,
    UploadModule,
    PlaceModule,
    ProjectModule,
    CoreModule,
    MapModule,
    BaseModule,
    AdvertiseModule
  ],
})
export class AppModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(LoggerMiddleware).forRoutes('*');
  }
}
