import * as moment from 'moment-timezone';
import * as jalali from 'jalali-moment';

export const localDate = (d: Date, format?: string): string => {
  return jalali(d).locale('fa').format('YYYY/MM/DD');
};

export const localTime = (d: Date): string => {
  return moment(d).tz('Asia/Tehran').format('HH:mm');
};

export const formatDate = (d: Date): string => {
  return moment(d).locale('fa').format('YYYY/MM/DD HH:mm');
};
