import { Injectable } from '@nestjs/common';
import axios, { AxiosInstance, AxiosResponse } from 'axios';
import { camelize } from '@ridi/object-case-converter';

@Injectable()
export class AxiosService {
  private _khaneavalOldServer: AxiosInstance = axios.create({
    baseURL: 'https://server.khanehaval.com',
  });

  private readonly _neshan: AxiosInstance = axios.create({
    baseURL: 'https://api.neshan.org/',
  });

  constructor() {
    this._khaneavalOldServer.interceptors.request.use(async (config: any) => {
      config.headers = {
        'Content-Type': 'application/json; charset=utf-8',
        Accept: 'application/json',
        Authorization: `CsLnBuDBG1CpZqsLUMHVc17hK5VjLLj1`,
      };
      return config;
    });

    this._neshan.interceptors.request.use(async (config: any) => {
      config.headers = {
        'Api-Key': `service.3395c2a9b0004e10a70f277b5efec4c3`,
      };
      return config;
    });

    this._khaneavalOldServer.interceptors.response.use((res: AxiosResponse) => {
      const data = res.data;
      return camelize(data, { recursive: true });
    });

    this._neshan.interceptors.response.use((res: AxiosResponse) => {
      const { status, location } = res.data;
      return location || {};
    });
  }

  get oldServer(): AxiosInstance {
    return this._khaneavalOldServer;
  }

  get neshan(): AxiosInstance {
    return this._neshan;
  }
}
