import { AuthGuard } from '@nestjs/passport';
import { ExecutionContext, UnauthorizedException } from '@nestjs/common';
import Dict from "~constants/dict"

export class JwtAuthGuard extends AuthGuard('jwt') {
  constructor() {
    super();
  }

  handleRequest(err:any, user: any, info: any, context: ExecutionContext) {
    if(!user) {
      throw new UnauthorizedException(Dict.NOT_AUTHENTICATED)
    }
    return user;
  }
}