import { runSeeders } from 'typeorm-extension';
import AppDataSource, { CreateDatabase } from './ds';

export default class Db {
  private static _status: boolean;
  private static _db: Db = new Db();

  private constructor() {}

  static get instance(): Db {
    return this._db;
  }

  static get status(): boolean {
    return this._status;
  }

  private static set status(value: boolean) {
    this._status = value;
  }

  static async connect() {
    try {
      await CreateDatabase();
      await AppDataSource.initialize();

      await runSeeders(AppDataSource);
      this.status = true;
    } catch (err) {
      console.log(err)
      this.status = false;
    }
  }

  static async seed() {}

  get ds() {
    return AppDataSource;
  }
}
