import { Column, Entity } from 'typeorm';
import { SharedEntity } from '../shared.entity';
import { ApiProperty } from '@nestjs/swagger';

export interface IFloorNumber {
  value?: number;
  title?: string;
}

@Entity()
export class FloorNubmer
  extends SharedEntity<IFloorNumber>
  implements IFloorNumber
{
  @ApiProperty()
  @Column({ nullable: true })
  value?: number;

  @ApiProperty()
  @Column({ nullable: true })
  title?: string;
}
