import { AfterLoad, BeforeInsert, ChildEntity, Column } from "typeorm";
import { IAge } from "../ads-params/age.entity";
import { IBuildingSide } from "../ads-params/builing-side.entity";
import { ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType } from "../ads-params/construction.entity";
import { ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { FloorNubmer, IFloorNumber } from "../ads-params/floor-number.entity";
import { IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IWC } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsNumber } from "class-validator";

@ChildEntity()
export class SaleOffice extends Advertise implements ISaleOffice {

  constructor(props?: ISaleOffice) {
    super(props);
  }

  @AfterLoad()
  afterLoad() {
    this.totalPrice = Number(this.totalPrice); 
  }

  @BeforeInsert()
  updateProps() {
    this.propertyType = 'sale-office';
    this.category = "commercial-sale";
  }

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  totalPrice?: number;

  meterage?: number;

  buildingType?: 'administrative' | 'clinic';

  @ApiProperty()
  @Column({ nullable: true, default: false })
  saleAsInstallment?: boolean;

  prepaymentPercent?: number;

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  prepayment?: number;

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  installmentAmount?: number;

  installmentNumber?: number;

  installmentPledge?: 'zamen' | 'safteh' | 'check';
  age?: IAge;
  room?: IRoom;
  floorNumber?: IFloorNumber;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGarage?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasElevator?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasStoreHouse?: boolean;

  totalFloors?: TotalFloorType;
  unitInFloor?: IUnitInEachFloor;
  totalUnits?: number;
  buildingSide?: IBuildingSide;
  reconstruct?: IReconstructionType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  administrativeDoc?:boolean;

  flooringMaterialType?: IFlooringMaterialType;
  cabinetType?: ICabinetType;
  wc?: IWC;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCentralAnthena?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCCTV?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasAlarm?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSecurityDoor?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSecurityRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasInternetMast?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasDinningSalon?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasFireExtinguishing?: boolean;

}

export interface ISaleOffice extends IAdvertise {
  totalPrice?: number;
  meterage?: number;
  buildingType?: 'administrative' | 'clinic';
  saleAsInstallment?: boolean;
  prepaymentPercent?: number;
  prepayment?: number;
  installmentAmount?: number;
  installmentNumber?: number;
  installmentPledge?: 'zamen' | 'safteh' | 'check';
  age?: IAge;
  room?: IRoom;
  floorNumber?: IFloorNumber;
  hasGarage?: boolean;
  hasElevator?: boolean;
  hasStoreHouse?: boolean;
  totalFloors?: TotalFloorType;
  unitInFloor?: IUnitInEachFloor;
  totalUnits?: number;
  buildingSide?: IBuildingSide;
  reconstruct?: IReconstructionType;
  administrativeDoc?:boolean;
  flooringMaterialType?: IFlooringMaterialType;
  cabinetType?: ICabinetType;
  wc?: IWC;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;

  hasCentralAnthena?: boolean;
  hasCCTV?: boolean;
  hasAlarm?: boolean;
  hasSecurityDoor?: boolean;
  hasSecurityRoom?: boolean;
  hasInternetMast?: boolean;
  hasDinningSalon?: boolean;
  hasFireExtinguishing?: boolean;
}