import { SharedEntity } from './shared.entity';
import {
  Column,
  Entity,
  JoinColumn,
  ManyToMany,
  ManyToOne,
  OneToMany,
  OneToOne,
} from 'typeorm';
import { AgencyEntity, IAgencyEntity } from './user/agency.entity';
import { IPlaceInfoEntity, PlaceInfoEntity } from './place-info.entity';
import { ApiProperty } from '@nestjs/swagger';
import { ConsultantEntity, IConsultantEntity } from './user/consultant.entity';
import { UserEntity } from './user.entity';

export type PlacesType =
  | 'country'
  | 'province'
  | 'county'
  | 'city'
  | 'area'
  | 'union';
@Entity({ name: 'places' })
export class PlaceEntity
  extends SharedEntity<IPlaceEntity>
  implements IPlaceEntity
{
  @ApiProperty()
  @Column({ nullable: true, type: 'varchar' })
  name?: string;

  @ApiProperty()
  @Column({ nullable: true, type: 'varchar' })
  eName?: string;

  @ApiProperty({
    enum: ['country', 'province', 'county', 'city', 'area', 'union'],
  })
  @Column({
    type: 'enum',
    enum: ['country', 'province', 'county', 'city', 'area', 'union'],
  })
  type?: PlacesType;

  @ManyToOne(() => PlaceEntity, (p) => p.children)
  parent?: IPlaceEntity;

  @OneToMany(() => PlaceEntity, (p) => p.parent)
  children?: IPlaceEntity[];

  @OneToOne(() => PlaceInfoEntity)
  @JoinColumn()
  info: IPlaceInfoEntity;

  @ManyToMany(() => ConsultantEntity, (c) => c.areas)
  consultants: ConsultantEntity[];

  @ManyToMany(() => AgencyEntity, (a) => a.areas)
  agencies: AgencyEntity[];
}

export interface IPlaceEntity {
  name?: string;

  eName?: string;

  type?: PlacesType;

  parent?: IPlaceEntity;

  children?: IPlaceEntity[];

  info?: IPlaceInfoEntity;
}
