import {
  AfterLoad,
  BaseEntity,
  CreateDateColumn,
  DeleteDateColumn,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';

export abstract class SharedEntity<T>
  extends BaseEntity
  implements ISharedEntity
{
  constructor(props?: T) {
    super();
    this.update(props);
  }

  update(props: any) {
    Object.assign(this, props);
  }

  @ApiProperty()
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @CreateDateColumn()
  createdAt: Date | string;

  @UpdateDateColumn()
  updatedAt: Date | string;

  @DeleteDateColumn({ select: false })
  deletedAt: Date;

  @AfterLoad()
  afterLoad() {
    try {
      // this.createdAt = localDate(this.createdAt as Date);
      // this.updatedAt = localTime(this.updatedAt as Date);
    } catch (err) {
      console.log(err);
    }
  }
}

export interface ISharedEntity {
  id?: string;

  createdAt?: Date | string;

  updatedAt?: Date | string;

  deletedAt?: Date | string;
}
