import { ChildEntity, Column, JoinTable, ManyToMany, ManyToOne } from 'typeorm';
import { IUserEntity, UserEntity } from '../user.entity';
import { IPlaceEntity, PlaceEntity } from '~db/entities/place.entity';

@ChildEntity()
export class ConsultantEntity extends UserEntity implements IConsultantEntity {
  constructor(props: IConsultantEntity) {
    super(props);
    this.subscriberType = 'consultant';
  }

  @Column()
  licenseImg?: string;

  @Column()
  nationalCode?: string;

  @Column({ nullable: true, type: 'json' })
  address?: any;

  @ManyToOne(() => PlaceEntity)
  city: IPlaceEntity;

  @ManyToMany(() => PlaceEntity, (p) => p.consultants)
  @JoinTable()
  areas: IPlaceEntity[];
}

export interface IConsultantEntity extends IUserEntity {
  address?: any;

  licenseImg?: string;

  city?: IPlaceEntity;

  areas?: IPlaceEntity[];

  nationalCode?: string;
}
