import { Column, Entity, ManyToOne } from 'typeorm';
import { SharedEntity } from '../shared.entity';
import { IUserEntity, UserEntity } from '../user.entity';

@Entity({ name: 'messages' })
export class MessageEntity
  extends SharedEntity<IMessageEntity>
  implements IMessageEntity
{
  @Column({ nullable: true, type: 'varchar', length: 6 })
  code?: string;

  @ManyToOne(() => UserEntity, (u) => u.messages)
  user?: IUserEntity;
}

export interface IMessageEntity {
  code?: string;

  user?: IUserEntity;
}
