import { Injectable, PipeTransform } from '@nestjs/common';
import { Age } from '~db/entities/ads-params/age.entity';
import { BuildingSide } from '~db/entities/ads-params/builing-side.entity';
import { CabinetType } from '~db/entities/ads-params/cabinet.entity';
import { ReconstructionType } from '~db/entities/ads-params/construction.entity';
import { CoolingSystemType } from '~db/entities/ads-params/cool-system-type.entity';
import { BuildingDocType } from '~db/entities/ads-params/doc.entity';
import { FloorNubmer } from '~db/entities/ads-params/floor-number.entity';
import { FlooringMaterialType } from '~db/entities/ads-params/flooring-material-type.entity';
import { HeatingSystemType } from '~db/entities/ads-params/heat-system-type.entity';
import { HeatWaterSystemType } from '~db/entities/ads-params/heat-water-system.entity';
import { Room } from '~db/entities/ads-params/room.entity';
import { TotalFloorType } from '~db/entities/ads-params/total-floor-type.entity';
import { UnitInEachFloor } from '~db/entities/ads-params/unit-in-each-floor.enity';
import { VillaTotalFloorType } from '~db/entities/ads-params/villa-total-floor-type.entity';
import { Wc } from '~db/entities/ads-params/wc.entity';
import { PlaceEntity } from '~db/entities/place.entity';
import { db } from '~db/repositories';

@Injectable()
export class AdversPipe implements PipeTransform {
  async transform(value: any) {
    const _places = db.getRepository(PlaceEntity);
    const _ages = db.getRepository(Age);
    const _sides = db.getRepository(BuildingSide);
    const _coolings = db.getRepository(CoolingSystemType);
    const _docTypes = db.getRepository(BuildingDocType);
    const _floorNumbers = db.getRepository(FloorNubmer);
    const _totalfloorTypes = db.getRepository(TotalFloorType);
    const _floorings = db.getRepository(FlooringMaterialType);
    const _heatings = db.getRepository(HeatingSystemType);
    const _heatWater = db.getRepository(HeatWaterSystemType);
    const _rooms = db.getRepository(Room);
    const _unitInFloors = db.getRepository(UnitInEachFloor);
    const _wcs = db.getRepository(Wc);
    const _cabinets = db.getRepository(CabinetType);
    const _reconstructTypes = db.getRepository(ReconstructionType);
    const _villaTotalFloorsType = db.getRepository(VillaTotalFloorType);

    let {
      cityId,
      districtId,
      age,
      room,
      floorNumber,
      docType,
      totalFloors,
      unitInFloor,
      buildingSide,
      flooringMaterialType,
      cabinetType,
      wc,
      coolingSystemType,
      heatingSystemType,
      heatWaterSystemType,
      reconstruct,
      villaTotalFloors,
      ...rest
    } = value || {};

    const city = await _places.findOneBy({ id: cityId });
    const district = await _places.findOneBy({ id: districtId });

    if (age) {
      age = await _ages.findOneBy({ id: age });
      rest = { ...rest, age };
    }

    if(reconstruct) {
      reconstruct = await _reconstructTypes.findOneBy({id: reconstruct});
      rest = {...rest, reconstruct}
    }

    if(villaTotalFloors) {
      villaTotalFloors = await _villaTotalFloorsType.findOneBy({id: villaTotalFloors});
      rest = {...rest, villaTotalFloors}
    }

    if (room) {
      room = await _rooms.findOneBy({ id: room });
      rest = { ...rest, room };
    }

    if (floorNumber) {
      floorNumber = await _floorNumbers.findOneBy({ id: floorNumber });
      rest = { ...rest, floorNumber };
    }

    if (totalFloors) {
      totalFloors = await _totalfloorTypes.findOneBy({ id: totalFloors });
      rest = { ...rest, totalFloors };
    }

    if (docType) {
      docType = await _docTypes.findOneBy({ id: docType });
      rest = { ...rest, docType };
    }

    if (unitInFloor) {
      unitInFloor = await _unitInFloors.findOneBy({ id: unitInFloor });
      rest = { ...rest, unitInFloor };
    }

    if (buildingSide) {
      buildingSide = await _sides.findOneBy({ id: buildingSide });
      rest = { ...rest, buildingSide };
    }

    if (flooringMaterialType) {
      flooringMaterialType = await _floorings.findOneBy({
        id: flooringMaterialType,
      });
      rest = { ...rest, flooringMaterialType };
    }

    if (cabinetType) {
      cabinetType = await _cabinets.findOneBy({ id: cabinetType });
      rest = { ...rest, cabinetType };
    }

    if (wc) {
      wc = await _wcs.findOneBy({ id: wc });
      rest = { ...rest, wc };
    }

    if (coolingSystemType) {
      coolingSystemType = await _coolings.findOneBy({ id: coolingSystemType });
      rest = { ...rest, coolingSystemType };
    }

    if (heatingSystemType) {
      heatWaterSystemType = await _heatings.findOneBy({
        id: heatingSystemType,
      });
      rest = { ...rest, heatingSystemType };
    }

    if (heatWaterSystemType) {
      heatWaterSystemType = await _heatWater.findOneBy({
        id: heatWaterSystemType,
      });
      rest = { ...rest, heatWaterSystemType };
    }


    return {
      ...rest,
      city,
      district,
      propertyType: 'apartment-sale',
      category: 'residence-sale',
    };
  }
}
