import { Module } from '@nestjs/common';
import { CqrsModule } from '@nestjs/cqrs';
import { AdvertisService } from './advers.service';
import { BaseAdvertiseController } from './base/base-advertise.controller';
import { GetAdvertiseListHandler } from './base/queries/GetAdvertiseList';
import { Ads } from '~db/entities/ads-types';
import { AdvertiseControllerMixin } from './advers.controller';

const controllers = Ads.map((x: any) => AdvertiseControllerMixin(x))
@Module({
  imports: [CqrsModule],
  controllers: [
    BaseAdvertiseController,
    ...controllers
  ],
  providers: [AdvertisService, GetAdvertiseListHandler],
})
export class AdvertiseModule {}
