import { IQueryHandler, QueryHandler } from '@nestjs/cqrs';
import { Advertise } from '~db/entities/advertise.entity';
import { db } from '~db/repositories';
import { QueryModel } from '~model/query';

const _advertsies = db.getRepository(Advertise);

class GetAdvertiseListQueryModel extends QueryModel {}

export class GetAdvertiseList {
  constructor(public query: GetAdvertiseListQueryModel) {}
}

@QueryHandler(GetAdvertiseList)
export class GetAdvertiseListHandler
  implements IQueryHandler<GetAdvertiseList>
{
  async execute({ query }: GetAdvertiseList): Promise<any> {
    const list = await _advertsies
      .createQueryBuilder('ads')
      .leftJoinAndSelect('ads.advertizer', 'advertizer')
      .leftJoinAndSelect('ads.city', 'city')
      .leftJoinAndSelect('ads.district', 'district')
      .select(['ads', 'advertizer', 'city', 'district'])
      .addSelect(['ads.propertyType', 'ads.category'])
      .getMany();
    return list;
  }
}
