import { ApiBody, ApiOkResponse, ApiTags } from '@nestjs/swagger';
import { Body, Controller, Post } from '@nestjs/common';
import { CommandBus } from '@nestjs/cqrs';
import { AdminLoginDto } from '~modules/auth/models/login';
import { AdminLoginCommand } from '~modules/auth/handlers';
import { VerifyResponse } from '~modules/auth/models/response/verify.response';

@ApiTags('Auth Admin')
@Controller('admin/auth')
export class AdminAuthController {
  constructor(private readonly command: CommandBus) {}

  @Post('login')
  @ApiBody({ type: AdminLoginDto })
  @ApiOkResponse({
    type: VerifyResponse,
  })
  async login(@Body() dto: AdminLoginDto): Promise<any> {
    return this.command.execute(new AdminLoginCommand(dto));
  }
}
