import { Body, Controller, Post} from '@nestjs/common';
import { ApiBody, ApiOkResponse, ApiTags } from '@nestjs/swagger';
import { CommandBus } from '@nestjs/cqrs';
import { LoginCommand, VerifyCommand } from '~modules/auth/handlers';
import { MessageResponse } from '~model/response';
import { VerifyResponse } from './models/response/verify.response';
import { LoginDto } from './models/login';
import { VerifyDto } from './models/verfiy';

@ApiTags('Auth')
@Controller('auth')
export class AuthController {
  constructor(private readonly command: CommandBus) {}

  @Post('login')
  @ApiBody({ type: LoginDto })
  @ApiOkResponse({
    type: MessageResponse
  })
  async login(@Body() dto: LoginDto): Promise<any> {
    return this.command.execute(new LoginCommand(dto))
  }

  @Post('verify')
  @ApiBody({ type: VerifyDto })
  @ApiOkResponse({
    type: VerifyResponse
  })
  async verify(@Body() dto: VerifyDto) {
    return this.command.execute(new VerifyCommand(dto))
  }
}
